/*
 * Decompiled with CFR 0.152.
 */
package me.theminddroid.drugs;

import java.util.List;
import java.util.Objects;
import me.theminddroid.drugs.DrugsPlugin;
import me.theminddroid.drugs.models.Drug;
import me.theminddroid.drugs.states.DrugUsageState;
import me.theminddroid.drugs.states.DrugWithdrawalState;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

public class DrugUtilities {
    public static boolean playerIsOnDrugs(Player player, Drug drug) {
        return DrugUtilities.getDrugUsage((Metadatable)player, drug) != null;
    }

    public static boolean playerIsOnDrugWithdrawal(Player player, Drug drug) {
        DrugWithdrawalState drugWithdrawalState = DrugUtilities.getDrugWithdrawal((Metadatable)player, drug);
        return drugWithdrawalState != null && drugWithdrawalState.withdrawalIsActive(DrugUtilities.getFullTime());
    }

    private static long getFullTime() {
        return ((World)Bukkit.getServer().getWorlds().get(0)).getFullTime();
    }

    public static void setPlayerWithdrawal(Player player, Drug drug) {
        player.setMetadata(DrugUtilities.getDrugWithdrawalKey(drug), (MetadataValue)new FixedMetadataValue((Plugin)DrugsPlugin.getInstance(), (Object)new DrugWithdrawalState(DrugUtilities.getFullTime())));
    }

    public static String getPreviousDrugUsageKey(Drug drug) {
        return "previousDrugUsage" + drug.name();
    }

    public static String getDrugWithdrawalKey(Drug drug) {
        return "drugWithdrawal" + drug.name();
    }

    public static DrugUsageState getDrugUsage(Metadatable metadatable, Drug drug) {
        MetadataValue previousDrugUsageValue = DrugUtilities.getOwnMetaData(metadatable, DrugUtilities.getPreviousDrugUsageKey(drug));
        if (previousDrugUsageValue == null) {
            return null;
        }
        return (DrugUsageState)previousDrugUsageValue.value();
    }

    public static DrugWithdrawalState getDrugWithdrawal(Metadatable metadatable, Drug drug) {
        MetadataValue drugWithdrawalValue = DrugUtilities.getOwnMetaData(metadatable, DrugUtilities.getDrugWithdrawalKey(drug));
        if (drugWithdrawalValue == null) {
            return null;
        }
        return (DrugWithdrawalState)drugWithdrawalValue.value();
    }

    public static MetadataValue getOwnMetaData(Metadatable metadatable, String key) {
        List metadataValues = metadatable.getMetadata(key);
        for (MetadataValue metadataValue : metadataValues) {
            if (!Objects.equals(metadataValue.getOwningPlugin(), (Object)DrugsPlugin.getInstance())) continue;
            return metadataValue;
        }
        return null;
    }
}

